/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.lexer;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import team.unnamed.mocha.lexer.Cursor;
import team.unnamed.mocha.lexer.MolangLexerImpl;
import team.unnamed.mocha.lexer.Token;
import team.unnamed.mocha.lexer.TokenKind;

@ApiStatus.NonExtendable
public interface MolangLexer
extends Closeable {
    @NotNull
    public static MolangLexer lexer(@NotNull Reader reader) throws IOException {
        return new MolangLexerImpl(reader);
    }

    @NotNull
    public static MolangLexer lexer(@NotNull String string) throws IOException {
        return MolangLexer.lexer(new StringReader(string));
    }

    @NotNull
    public static List<Token> tokenizeAll(@NotNull Reader reader) throws IOException {
        try (MolangLexer lexer = MolangLexer.lexer(reader);){
            List<Token> list = lexer.tokenizeAll();
            return list;
        }
    }

    @NotNull
    public static List<Token> tokenizeAll(@NotNull String string) throws IOException {
        try (MolangLexer lexer = MolangLexer.lexer(string);){
            List<Token> list = lexer.tokenizeAll();
            return list;
        }
    }

    @NotNull
    public Cursor cursor();

    @NotNull
    public Token current();

    @NotNull
    public Token next() throws IOException;

    @NotNull
    default public List<Token> tokenizeAll() throws IOException {
        Token token;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((token = this.next()).kind() != TokenKind.EOF) {
            tokens.add(token);
        }
        return tokens;
    }

    @Override
    public void close() throws IOException;
}

